import {NgModule} from '@angular/core';
import {RouterModule, Routes} from '@angular/router';

import {AppGuard} from './app.guard';

import {PublicComponent} from '../layouts/public/public.component';
import {ProtectedComponent} from '../layouts/protected/protected.component';
import {LoginComponent} from '../users/login/login.component';
import {ForgotComponent} from '../users/forgot/forgot.component';
import {NewPasswordComponent} from '../users/new-password/new-password.component';

const routes: Routes = [
    {
        path: 'dashboard',
        canActivate: [AppGuard],
        data: {roles: ['admin']},
        component: ProtectedComponent,
        children: []
    },
    {
        path: '',
        component: PublicComponent,
        children: [
            {
                path: '',
                component: LoginComponent,
            },
            {
                path: 'forgot',
                component: ForgotComponent,
            },
            {
                path: 'set-new/:token',
                component: NewPasswordComponent,
            },
            {
                path: 'set-new/:token/:reason', // reason is optional, reason for 2 routes
                component: NewPasswordComponent,
            }
        ]
    },
];

@NgModule({
    imports: [
        RouterModule.forRoot(routes)
    ],
    exports: [
        RouterModule
    ],
    declarations: [],
    providers: [
        AppGuard
    ]
})
export class RoutesModule {
}
