import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {FormsModule} from '@angular/forms';
import {RouterModule} from '@angular/router';
import {LocalStoreService} from '../app-services/local-store.service';
import {LoginComponent} from './login/login.component';

import {UserService} from './user.service';
import {LoaderComponent} from '../shared/loader/loader.component';
import {ForgotComponent} from './forgot/forgot.component';
import {NewPasswordComponent} from './new-password/new-password.component';
import {PermissionsService} from './permissions.service';

@NgModule({
    imports: [
        CommonModule,
        FormsModule,
        RouterModule
    ],
    providers: [
        UserService,
        PermissionsService,
        LocalStoreService
    ],
    declarations: [LoginComponent, LoaderComponent, ForgotComponent, NewPasswordComponent]
})
export class UsersModule {
}