let env = 'local';
let API_URL;
const APP_URLS = {
    login: '/',
    dashboard: '/dashboard',
    forgetPassword: '/forgot',
    newPassword: '/set-new'
};
const PERMISSIONS = {
    /** Admin Dashboard */
    AdminDashboard: 'AdminDashboard',

    /** Users Dashboard */
    UserDashboard: 'UserDashboard',

    /** Management Dashboard */
    Dashboard_UsersLogins: 'Dashboard_UsersLogins',
    Dashboard_UsersLoginsReport: 'Dashboard_UsersLoginsReport',
    Dashboard_ManagersLogins: 'Dashboard_ManagersLogins',
    Dashboard_ManagersLoginsReport: 'Dashboard_ManagersLoginsReport',
    Dashboard_Projects: 'Dashboard_Projects',
    Dashboard_ProjectsReports: 'Dashboard_ProjectsReports',
    _Dashboard: 'Dashboard_', // generic permission for dashboard access

    /** Projects */
    Projects_All: 'Projects_All',
    Projects_Own: 'Projects_Own',
    _Projects: 'Projects_' // generic permission for projects access
};
const RIGHTS = {
    Create: 'create',
    Read: 'read',
    Update: 'update',
    Delete: 'delete'
};


if (window.location.hostname.indexOf('stage') === -1) {
    env = 'stage';
} else {
    env = 'prod';
}

if (env === 'prod') {
    API_URL = 'http://localhost/';//will be set after deployment
} else {
    API_URL = 'http://localhost/';
}

export class Constants {
    public static get API_URL(): string {
        return API_URL;
    }

    public static get APP_URLS(): any {
        return APP_URLS;
    }

    public static get PERMISSIONS(): any {
        return PERMISSIONS;
    }

    public static get RIGHTS(): any {
        return RIGHTS;
    }
}
