import {BrowserModule} from '@angular/platform-browser';
import {ToastModule} from 'ng2-toastr/ng2-toastr';
import {NgModule} from '@angular/core';
import {HttpModule} from '@angular/http';
import {FormsModule} from '@angular/forms';

import {LayoutsModule} from './layouts/layouts.module';
import {RoutesModule} from './routes/routes.module';

import {AppComponent} from './app.component';
import {BrowserAnimationsModule} from '@angular/platform-browser/animations';
import { ModalModule } from 'ngx-bootstrap/modal';

import {HttpService} from './app-services/http.service';
import { SessionModalComponent } from './shared/session-modal/session-modal.component';

@NgModule({
    declarations: [
        AppComponent,
        SessionModalComponent
    ],
    imports: [
        BrowserModule,
        LayoutsModule,
        RoutesModule,
        HttpModule,
        FormsModule,
        BrowserAnimationsModule,
        ToastModule.forRoot(),
        ModalModule.forRoot()
    ],
    entryComponents: [ SessionModalComponent ],
    providers: [
        HttpService
    ],
    bootstrap: [AppComponent]
})
export class AppModule {
}
