import {Component, OnInit} from '@angular/core';
import {Constants} from '../../constants';
import {UserService} from '../../users/user.service';
import {Router} from '@angular/router';

@Component({
    selector: 'app-protected',
    templateUrl: './protected.component.pug',
    styleUrls: ['./protected.component.less']
})
export class ProtectedComponent implements OnInit {
    currentYear;
    userPopup = false;
    dashboardURL = Constants.APP_URLS.dashboard;

    constructor(private user: UserService, private router: Router) {
    }

    ngOnInit() {
        this.currentYear = new Date().getFullYear();
    }

    toggleUserPopup(event) {
        console.log(event);
        event.stopPropagation();
        this.userPopup = !this.userPopup;
    }

    hideUserPopup() {
        this.userPopup = false;
    }

    logout() {
        this.user.logout().subscribe(data => {
            this.router.navigate([Constants.APP_URLS.login]);
        });
    }

}
