import {NgModule} from '@angular/core';
import {RouterModule, Routes} from '@angular/router';

import {AppGuard} from './app.guard';

import {PublicComponent} from '../layouts/public/public.component';
import {ProtectedComponent} from '../layouts/protected/protected.component';

const routes: Routes = [
    {
        path: 'admin',
        canActivate: [AppGuard],
        data: {roles: ['admin']},
        component: ProtectedComponent,
        children: []
    },
    {
        path: '',
        component: PublicComponent,
        children: []
    },
];

@NgModule({
    imports: [
        RouterModule.forRoot(routes)
    ],
    exports: [
        RouterModule
    ],
    declarations: [],
    providers: [
        AppGuard
    ]
})
export class RoutesModule {
}
